# KineDiff3D: Kinematic-Aware Diffusion for Category-Level Articulated Object Shape Reconstruction and Generation

## Installation
We recommend creating an [anaconda](https://www.anaconda.com/) environment using our provided `environment.yml`:

```
conda env create -f environment.yml
conda activate KineDiff3D
```

## Dataset
Download our generated dataset from ArtImage at [BaiduYun(code:o2ou)](https://pan.baidu.com/s/1vyEL3uvvaT1dNvpZc4jyIg?pwd=o2ou) and [OneDrive](https://onedrive.live.com/?cid=0CEC31BD19A86C5F&id=CEC31BD19A86C5F%21s618290dc5a61431fa6b3ced1732bde45&parId=root&o=OneUp), and save in ```/data```.
Stay tuned. (1) Manifold to create watertight meshes, (2) and modified mesh_to_sdf for generating sampled points and sdf values. Generate samples use:
```
python ArtImage_getitem.py
```

## Training
1. Training Kinematic-Aware Shape Prior
Take Laptop as example:
```
python train.py -e config/laptop/stage1_sdf/ -b 32 -w 8    # -b for batch size, -w for workers, -r to resume training
```

2. Training the diffusion model using the Shape Prior extracted from the first stage 

```
# extract the modulations / latent vectors, which will be saved in a "modulations" folder in the config directory

python test.py -e config/stage1_sdf/ -r last

# diffusion
python train.py -e config/laptop/stage2_diff_cond/diffusion -b 32 -w 8 
```

3.Training the score model  
```
python train.py -e config/laptop/stage2_diff_cond/score -b 32 -w 8 
```

4.End-to-end training using the saved models from above 

```
# conditional
python train.py -e config/stage3_cond/ -b 32 -w 8 -r finetune    # training from the saved models of first two stages
python train.py -e config/stage3_cond/ -b 32 -w 8 -r last     # resuming training if third stage has been trained 
```

## Testing
1. Testing SDF reconstructions and saving modulations

After the first stage of training, visualize / test reconstructions and save modulations:
```
python test.py -e config/stage1_sdf/ -r last
```

2. Evaluate
```
python  evaluate.py -e config/laptop/stage3_cond/ -r finetune -n 5
```